@echo off
REM Build and Install kc_mod_eafe47e5 Mod for BG3
REM Generated by Karsus Codex - New Pipeline
REM
REM IMPORTANT: This file expects to be extracted to:
REM   %CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478
REM
REM Paths are relative to the extracted folder. Override DIVINE or BG3_MODS via env vars if needed:
REM   set DIVINE=C:\Tools\LSLib\Tools\Divine.exe
REM   set BG3_MODS=%LOCALAPPDATA%\Larian Studios\Baldur's Gate 3\Mods

set "DIVINE=%DIVINE%"
if "%DIVINE%"=="" set "DIVINE=%CD%\\Tools\\Divine.exe"
set "BG3_MODS=%BG3_MODS%"
if "%BG3_MODS%"=="" set "BG3_MODS=%LOCALAPPDATA%\\Larian Studios\\Baldurs Gate 3\Mods"

echo ========================================
echo Building kc_mod_eafe47e5
echo ========================================

REM Check if Divine.exe exists
if not exist "%DIVINE%" (
    echo ERROR: Divine.exe not found at %DIVINE%
    echo.
    echo Please download LSLib from: https://github.com/Norbyte/lslib/releases
    echo Extract to a folder and set DIVINE env var to the full path, e.g.:
    echo   set DIVINE=C:\Tools\LSLib\Tools\Divine.exe
    exit /b 1
)

REM Converting RootTemplate: b7fae645-420b-5850-93bb-75d7ae706ecb
echo.
echo Converting RootTemplate b7fae645-420b-5850-93bb-75d7ae706ecb...
"%CD%\\Tools\\Divine.exe" --action convert-resource --source "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\Public\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\RootTemplates\b7fae645-420b-5850-93bb-75d7ae706ecb.lsx" --destination "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\Public\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\RootTemplates\b7fae645-420b-5850-93bb-75d7ae706ecb.lsf" --output-format lsf --game bg3

if %ERRORLEVEL% neq 0 (
    echo ERROR: Failed to convert RootTemplate b7fae645-420b-5850-93bb-75d7ae706ecb
    exit /b 1
)

del "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\Public\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\RootTemplates\b7fae645-420b-5850-93bb-75d7ae706ecb.lsx"


REM Convert GUI metadata from .lsx to .lsf
echo.
echo Converting GUI metadata to .lsf format...
"%DIVINE%" --action convert-resource --source "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\Mods\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\GUI\metadata.lsx" --destination "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\Mods\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\GUI\metadata.lsf" --output-format lsf --game bg3

if %ERRORLEVEL% neq 0 (
    echo ERROR: Failed to convert GUI metadata
    exit /b 1
)

del "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\Mods\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478\GUI\metadata.lsx"

REM Create the .pak file
echo.
echo Creating .pak file...
"%DIVINE%" --action create-package --game bg3 --source "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478" --destination "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478.pak"

if %ERRORLEVEL% neq 0 (
    echo ERROR: Failed to create .pak file
    exit /b 1
)

REM Copy to BG3 Mods folder
echo.
echo Installing to BG3 Mods folder...
if not exist "%BG3_MODS%" (
    echo ERROR: BG3 Mods folder not found at %BG3_MODS%
    echo Please check your BG3 installation
    exit /b 1
)

copy /Y "%CD%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478.pak" "%BG3_MODS%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478.pak"

if %ERRORLEVEL% neq 0 (
    echo ERROR: Failed to copy .pak to Mods folder
    exit /b 1
)

echo.
echo ========================================
echo SUCCESS!
echo ========================================
echo Mod installed to: %BG3_MODS%\kc_mod_eafe47e5_966436ab-94d1-45cb-8047-0a6a413c9478.pak
echo.
echo To enable:
echo 1. Launch BG3
echo 2. Open Mod Manager (Mods tab)
echo 3. Enable kc_mod_eafe47e5
echo 4. Start/load a game
echo.
